//
// Created by 76538 on 2/15/2021.
//
#include <cstring>

#include "nanovoid.h"
#include "SuperFastHash.h"

using namespace std;

////////////////////// HashPointer ///////////////////////////
HashPointer::HashPointer(uint _K) :
  K(_K), hash_code(UINT_NULL), pnb(UINT_NULL)
{
  lsh_hash_code = new int[_K];
}

HashPointer::~HashPointer() {
  delete [] lsh_hash_code;
}


HashPointer::HashPointer(const HashPointer& b) :
  K(b.K), hash_code(b.hash_code), pnb(b.pnb)
{
  lsh_hash_code = new int[K];
  memcpy(lsh_hash_code, b.lsh_hash_code, sizeof(int)*K);
}


///////////////////// HashPointerBank ////////////////////////
HashPointerBank::HashPointerBank(uint _K, uint init_size) :
  K(_K), freed(init_size, 0), num_freed(init_size),  \
  d(0, HashPointer(_K))
{
  // printf("In HashPointerBank constructor\n");
  fflush(stdout);
  uint i = 0;
  for (i = 0; i < init_size; ++ i) {
    //HashPointer* di = new HashPointer(K);
    d.push_back(HashPointer(K));
  }
  i = 0;
  for (list<uint>::iterator it = freed.begin(); it != freed.end(); ++ it){
    *it = i;
    ++i;
  }
  // printf("Exit HashPointerBank constructor\n");
  fflush(stdout);
}

uint HashPointerBank::new_elem() {
  if (num_freed == 0) {
    // too small; double the size;
    uint s = d.size();
    uint i = 0;
    //d.insert(d.end(), s, ListElem());
    for ( ; i < s; ++ i) {
      HashPointer* di = new HashPointer(K);
      d.push_back(*di);
    }
    num_freed = s;
    for (uint i = s; i < s+s; ++i)
      freed.push_back(i);
  }
  
  --num_freed;
  uint p = freed.front();
  freed.pop_front();
  return p;
}

bool HashPointerBank::free_elem(uint k) {
  d[k].hash_code = UINT_NULL; // mark it has been freed
  d[k].pnb = UINT_NULL;
  
  freed.push_front(k);
  ++num_freed;
  return true;
}


///////////////////// PNBucketBank ////////////////////////
PNBucketBank::PNBucketBank(uint init_size) :
  freed(init_size, 0), num_freed(init_size),  \
  d(init_size), n_list_hash(1024, 65535, 999983)
{
  // printf("In PNBucketBank constructor\n");
  fflush(stdout);
  uint i = 0;
  for (i = 0; i < init_size; ++ i) {
    d[i].p_list = UINT_NULL;
    d[i].n_list_id = UINT_NULL;
  }
  i = 0;
  for (list<uint>::iterator it = freed.begin(); it != freed.end(); ++ it){
    *it = i;
    ++i;
  }
  // printf("Exit PNBucketBank constructor\n");
  fflush(stdout);
}

uint PNBucketBank::new_elem() {
  if (num_freed == 0) {
    // too small; double the size;
    uint s = d.size();
    uint i = 0;
    for ( ; i < s; ++ i) {
      PNBucket* di = new PNBucket();
      di->p_list = UINT_NULL;
      di->n_list_id = UINT_NULL;
      d.push_back(*di);
    }
    num_freed = s;
    for (uint i = s; i < s+s; ++i)
      freed.push_back(i);
  }
  
  --num_freed;
  uint p = freed.front();
  freed.pop_front();
  d[p].n_list_id = n_list_hash.new_id();
  return p;
}

bool PNBucketBank::free_elem(uint k) {
  d[k].p_list = UINT_NULL; // mark it has been freed
  n_list_hash.clear(d[k].n_list_id);
  n_list_hash.del_id(d[k].n_list_id);
  d[k].n_list_id = UINT_NULL; 
  
  freed.push_front(k);
  ++num_freed;
  return true;
}



///////////////////// HashTable ////////////////////////


uint HashTable::hash_from_lsh(int* x) {
  //std::size_t real_hash_code = int_hash(x);
  uint32_t h = SuperFastHash(reinterpret_cast <char* const> (x), sizeof(int)*K);
  return h % hash_size;
}

uint HashTable::l_loc_from_hash(uint hash, uint wh) {
  if (h[wh][hash] != UINT_NULL)
    return h[wh][hash];
  
  //l.resize(l.size() + 1);
  //printf("l_loc_from_hash append: ");
  vector< uint >* it = new vector< uint >(0);
  l[wh].push_back(*it);

  l2h[wh].push_back(hash);
  
  h[wh][hash] = (uint)l[wh].size() - 1;
  //printf("h[hash]=%u done\n", h[hash]);
  return h[wh][hash];
}

HashTable::HashTable(uint _K, uint _L, uint _hash_size) :
  K(_K), L(_L), hash_size(_hash_size), 
  h(_L), l(_L), l2h(_L),
  hp(_K)
{
  for (uint i = 0; i < L; ++ i)
    h[i].insert(h[i].end(), hash_size, UINT_NULL);
}

/*
XYX: seems no special operations needed for the new data structure.
HashTable::~HashTable() {
  vector< list< HashBucket* > >::iterator it;
  for (it = l.begin(); it != l.end(); ++ it) {
    list< HashBucket* >::iterator itt;
    for (itt = it->begin(); itt != it->end(); ++ itt)
      delete *itt;
  }
}
*/

uint HashTable::find(int* lsh_code, uint wh) {
  uint l_loc = h[wh][hash_from_lsh(lsh_code)];
  if (l_loc == UINT_NULL)
    return UINT_NULL;
  vector< uint >::iterator it = l[wh][l_loc].begin();
  for (; it != l[wh][l_loc].end(); ++ it) {
    if (memcmp(hp.d[*it].lsh_hash_code, lsh_code, sizeof(int)*K) == 0)
      return *it;
  }
  return UINT_NULL;
}

void HashTable::insert(uint t_hp, uint hash_code, uint wh) {
  uint l_loc = l_loc_from_hash(hash_code, wh);
  l[wh][l_loc].push_back(t_hp);
}

void HashTable::move_out(uint t_hp, int* lsh_code, uint wh) {
  uint l_loc = h[wh][hash_from_lsh(lsh_code)];
  if (l_loc == UINT_NULL) {
    printf("Error in HashTable::move_out, did not find the element! L_LOC=NULL\n");
    fflush(stdout);
    assert(false);
  }
  vector< uint >::iterator it = l[wh][l_loc].begin();
  for (; it != l[wh][l_loc].end(); ++ it)
    if ((*it) == t_hp) {
      l[wh][l_loc].erase(it);
      return;
    }
  printf("Error in HashTable::move_out, did not find the element!\n");
  fflush(stdout);
  assert(false);
}


void HashTable::print_hash_table_v2() {
  uint hash_L = 0;
  for (vector< vector< vector< uint > > >::iterator it1 = l.begin(); it1 != l.end(); ++ it1){
    printf("## hash_L=%u\n", hash_L);
    uint lid = 0;
    for (vector< vector< uint > >::iterator it = it1->begin(); it != it1->end(); ++ it) {
      printf("  l.id=%u, it->size()=%lu\n", lid, it->size());
      if (it->size() > 0) {
        printf("  [");
        vector< uint >::iterator itt = it->begin();
        for ( ; itt != it->end(); ++ itt) {
          printf("%u, ", *itt);
          //assert(hash_from_lsh((*itt)->lsh_hash_code) == (*itt)->hash_code);
          //assert(h[hash_L][(*itt)->hash_code] == lid);
        }
        printf("]\n");
      }
      ++lid;
    }
    ++hash_L;
  }  
}


void HashTable::clean_up_l_list() {
  uint wh = 0;
  for (vector< vector< vector< uint > > >::iterator it1 = l.begin(); it1 != l.end(); ++ it1){
    uint processed = 0;
    uint not_empty = 0;
    while (processed < it1->size()) {
      while (processed < it1->size() && (*it1)[processed].size() == 0) {
        h[wh][l2h[wh][processed]] = UINT_NULL;
        ++processed;
      }
      if (processed < it1->size()) {
        if (processed != not_empty) {
          h[wh][l2h[wh][processed]] = not_empty;
          l2h[wh][not_empty] = l2h[wh][processed];
          l[wh][not_empty].insert(l[wh][not_empty].end(), l[wh][processed].begin(), \
                                  l[wh][processed].end());
          l[wh][processed].clear();
        }
        ++not_empty;
        ++processed;
      }
    }
    l[wh].resize(not_empty);
    l2h[wh].resize(not_empty);
    ++wh;
  }  
}

/*
XYX: TODO
void HashTable::print_hash_table(UnionFindDelete& inv, const char* bucket_file) {
  vector<uint> bucket_sizes;
  vector< list< HashBucket* > >::iterator it;
  uint lid = 0;
  for (it = l.begin(); it != l.end(); ++ it) {
    printf("l.id=%u it->size()=%lu\n", lid, it->size());
    list< HashBucket* >::iterator itt = it->begin();
    for ( ; itt != it->end(); ++ itt) {
      
      assert(hash_from_lsh((*itt)->lsh_hash_code) == (*itt)->hash_code);
      assert(h[(*itt)->hash_code] == lid);
      
      assert(inv.isroot(inv.item2pd[(*itt)->p_list]));

      uint bucket_size = inv.d_size(inv.item2pd[(*itt)->p_list]);
      printf("  itt.size=%u itt.nlist.size=%lu \n", bucket_size, (*itt)->n_list.size());
      bucket_sizes.push_back(bucket_size);
    }
    ++lid;
  }

  FILE* oup = fopen(bucket_file, "w");
  lid = 0;

  fprintf(oup, "list=[");
  bool first = true;
  for (it = l.begin(); it != l.end(); ++ it) {
    list< HashBucket* >::iterator itt = it->begin();
    for ( ; itt != it->end(); ++ itt) {

      if (first) {
        fprintf(oup, "[");
        first = false;
      }else{
        fprintf(oup, ", [");
      }
      
      uint root = (inv.item2pd[(*itt)->p_list]);
      inv.print_recursive_tree_items(root, root, oup);
      fprintf(oup, "]");

    }
    ++lid;
  }
  fprintf(oup, "]\n");
  fclose(oup);
  
  printf("[BUCKET SIZES N=%lu] [", bucket_sizes.size());
  for (lid = 0; lid < bucket_sizes.size() - 1; ++ lid)
    printf(" %u,", bucket_sizes[lid]);
  printf(" %u]\n", bucket_sizes[bucket_sizes.size()-1]);
  
}
*/
